class Player extends Phaser.Physics.Arcade.Sprite {
    constructor(scene, xPos, yPos, texture) {
        super(scene, xPos, yPos, texture);
        // had to do this to create a physics body 
        scene.physics.add.existing(this);
        // set up the physics properties 
        this.body.setSize(50, 60, true);
        this.setBounce(0.2);
        this.setCollideWorldBounds(true);
        //Add is to the scene to make it visible/active etc 
        scene.add.existing(this);
    } // End of constructor() 

  
    updateMe(cursors) {
        // Move around the player
        if (cursors.left.isDown) {
            this.setVelocityX(-230);
            //sets the velocity in the x axis
            this.anims.play('left', true);
            // plays animation for the player sprite.

        } else if (cursors.right.isDown) {
            this.setVelocityX(230);
            //sets the velocity in the x axis
            this.anims.play('right', true);
             // plays animation for the player sprite.

        } else   {
            this.setVelocityX(0);
            this.anims.play('turn');
            // plays animation for the player sprite.

        }
        if (cursors.up.isDown) {
            this.setVelocityY(-230);
            //sets the velocity in the y axis
            this.anims.play('up', true);
            // plays animation for the player sprite.
            this.flipY=false;
            //resets the sprite flip to the base spritesheet

        }
        else if (cursors.down.isDown) {
        this.setVelocityY(500);
        //sets the velocity in the y axis
        this.anims.play('down', true);
        // plays animation for the player sprite.
        this.flipY=true;
            // flips the sprite 180 degrees. 
        }
        
        
    } /** end of updateMe() */
} /** end of class */